 aR  w Q m^9      h	 oP     nSystem-wide%SET (PCAT, 1)
$NOLIST

    NAME CpMain

; This is Pc.main.asm~text~
; This module contains all the routines of the CompassProm which are system dependent


DGROUP GROUP DATA
CGROUP GROUP CODE

    PUBLIC DataFrame, keyboardStatusKey, KeyHandlerOff

    PUBLIC CpSetTimerHandler
    PUBLIC CpSetKeyHandler, CpCatchAll
    PUBLIC CpEnableInterrupt, CpDisableInterrupt
    PUBLIC CpSetInterrupt, CpEndOfInterrupt
    PUBLIC CpSystemTick, GlitchInt
    PUBLIC tickGranularity, CompassPromStart, CpAddressOf
    PUBLIC CpMachineID, CpConLineOut, CpRealTimeClock

    EXTRN TimerInterrupt:FAR, InitMultiTasking:FAR
    EXTRN InitTheKeyboard: NEAR

    EXTRN systemType: BYTE, intMask1: BYTE
    EXTRN osProcessQ: BYTE, sysCounter: DWORD
    EXTRN gridMachine: BYTE, ibmMachineType: BYTE, pDosInt71Routine: DWORD
$EJ

; System Types

IBMPC         EQU 2
IBMAT         EQU 3

; IBM Machine Types

ps2Model30    EQU 0FAH

; IBM-PC constants

PcSystemTick  EQU 8 * 4      ; real system tick interrupt
PcKeyboardInt EQU 9 * 4      ; keyboard interrupt

; error #'s

eOk      EQU 0
eTimeOut EQU 253

; interrupt ID's

int8087       EQU 0     
intGpib       EQU 1
intKeyboard   EQU 2
intVertSync   EQU 3     ; Not used
intSysTick    EQU 3
intModem      EQU 4     
intBubble     EQU 5     ; Currently not used
intSerial     EQU 6
intRing       EQU 7
int0          EQU 8     ; mapped as physical 0
int1          EQU 9     ;                    1
int2          EQU 10    ;                    2
int3          EQU 11    ;                    3
int4          EQU 12    ;                    4
int5          EQU 13    ;                    5
int6          EQU 14    ;                    6
int7          EQU 15    ;                    7
intGlitch     EQU int7

; These are only valid on PC-AT architecture machines

int0Ctlr2     EQU 16    ; mapped as physical 0 (interrupt controller 2)
int1Ctlr2     EQU 17    ;                    1
int2Ctlr2     EQU 18    ;                    2
int3Ctlr2     EQU 19    ;                    3
int4Ctlr2     EQU 20    ;                    4
int5Ctlr2     EQU 21    ;                    5
int6Ctlr2     EQU 22    ;                    6
int7Ctlr2     EQU 23    ;                    7


; Interrupt Controller 1

interruptEOI    EQU 20h  ; End of Interrupt set by doing OUT
interruptPend   EQU 20h  ; Interrupts pending found by doing IN
intMask         EQU 21h  ; Interrupts Enabled Mask - Ctlr 1
intBase         EQU 08h  ; use interrupts 8 through 15 (decimal) on PC
specificEOIBase EQU 60h

; Interrupt Controller 2

interruptEOI2   EQU 0A0h ; End of Interrupt set by doing OUT
interruptPend2  EQU 0A0h ; Interrupts pending found by doing IN
intMask2        EQU 0A1h ; Interrupts Enabled Mask - Ctlr 2
intBase2        EQU 68h  ; This is newIntVector in SysDep.Plm module
ctlr2IntEOI     EQU 62h  ; Specific EOI Base + Intr Ctlr 2 Cascade interrupt

; Timer ports

timerControl    EQU 43h
timerSet        EQU 40h


; catch all constants (Most of these are not supported anymore)

catchReadDelayRepeat EQU 0
catchWriteDelayRepeat EQU 1
catchReadStatusKey EQU 2
catchSysControl EQU 3
catchRepeat EQU 4
catchKeyboard EQU 5
catchWatchdog EQU 6
catchBlank EQU 7
catchInvert EQU 8
catchDma EQU 9
catchResetWatchDog EQU 10
catchSetWatchDog EQU 11
catchReadKbdStatus EQU 12
catchReadDelayGranularity EQU 13
catchReadRepeatGranularity EQU 14
catchSetKeyboardMode EQU 15
catchSetStatusKey EQU 16

; Keyboard constants

initialDelayRepeat EQU 0FF15h  ; delay = 420ms, interval = 35ms
delayGranularity   EQU 16      ; # 100 uSec intervals
repeatGranularity  EQU 16      ; # 100 uSec intervals
$EJ

DATA SEGMENT PUBLIC 'DATA'

interruptCounter    DB ?     ; counts # interrupts

oldSysTickOff       DW ?     ; old Pc system tick interrupt
oldSysTickSeg       DW ?

timerHandlerOff     DW ?     ; timer handler
timerHandlerSeg     DW ?

keyHandlerOff       DW ?
keyHandlerSeg       DW ?     ; address of current key handler routine

keyboardDelayRepeat DW ?     ; the current delay and repeat values
keyboardStatusKey   DW ?     ; the previous status and character of keyboard
keyboardCommandLow  DB ?     ; current low byte of command

DATA ENDS

CODE SEGMENT BYTE PUBLIC 'CODE'
     ASSUME CS:CGROUP, DS:DGROUP

Version         DB 1,  'A'
Copyright       DB 27, 'Copyright 1987 GRiD Systems'

DataFrame       DW DGROUP    ; group of data

tickGranularity DW 14        ; system tick granularity


; interrupt table
; This table will map a virtual interrupt ID to its real priority mask
; 8 means unused

interruptTable DB 8, 8, 1, 0, 8, 8, 4, 8   ; Logical int IDs
               DB 0, 1, 2, 3, 4, 5, 6, 7   ; Physical int IDs - Controller 1
               DB 0, 1, 2, 3, 4, 5, 6, 7   ; Physical int IDs - Controller 2

; This table is the same as interruptTable except everything is a power of 2

interruptMask  DB 0, 0, 2, 1, 0,  0,  16, 0   ; Logical int IDs
               DB 1, 2, 4, 8, 16, 32, 64, 128 ; Physical int IDs - Contrller 1
               DB 1, 2, 4, 8, 16, 32, 64, 128 ; Physical int IDs - Contrller 2

%IF (%PCAT) THEN
(
;    PopFlags: PROCEDURE 
;
; This routine is required on the 286 in order to pop flags from
; the stack.  This is due to a 286 bug.  
;
PopFlags PROC NEAR
  IRET
PopFlags ENDP
)
FI
$EJ

;    CpEnableInterrupt : PROCEDURE (interruptID, mode) CLEAN;
;        DCL (interruptID, mode) BYTE;
;
;    This will enable the interrupt of the given ID.  It will not
;    change the state of any other interrupts.

gLinkMaskCtlr2 EQU 2

mode           EQU BYTE PTR [BP+6]
interruptID    EQU BYTE PTR [BP+8]

CpEnableInterrupt PROC FAR
   PUSH BP
   MOV  BP, SP

   MOV  BH, 0
   MOV  BL, interruptID

   MOV  ES, CS:DataFrame
   CMP  ES:ibmMachineType, ps2Model30 ; If this is not an IBM PS2/Model 30
   JNE  CpEnableCont                ; then don't make special keyboard check

   TEST ES:gridMachine, 1           ; If it is GRiD's Model 30
   JNZ  CpEnableCont                ; also don't need to make the check

   CMP  BL, intKeyboard             ; Else if trying to enable keyboard
   JE   CpEnableIntExit             ; then don't!
   
CpEnableCont:
   MOV  AH, CS:interruptMask[BX]    ; AH = mask
   NOT  AH                          ; prepare for reseting bit

   MOV  DX, intMask                 ; assume interrupt controller 1

   CMP  BL, int0Ctlr2               ; If not for interrupt controller 2
   JB   CpEnableIntHere             ; then no special checks needed

   CMP  ES:systemType, IBMAT        ; If not on an AT architecture machine
   JNE  CpEnableIntExit             ; then don't do anything

;;; Begin strange change to fix 'dangling GRiDLink interrupts on
;;; second interrupt controller when exiting InteGRiD' problem

;  A note: The var intMask1 even though similar namewise to intMask & intMask2
;          has nothing to do with intMask or intMask2.  It is the saved state
;          of the intr mask for the second controller (Saved in Sysdep).

   CMP  BL, int1Ctlr2               ; If not enabling GLink on 2nd intr ctlr
   JNE  CpEnableIntNotGLink         ; then don't do the kludg -o- rama

   OR   ES:intMask1, gLinkMaskCtlr2 ; Mask off GLink mask on 2nd intr ctlr

;;; End of strange change to fix dangling GRiDLink interrupts ... problem

CpEnableIntNotGLink:
   MOV  DX, intMask2                ; interrupt controller 2

CpEnableIntHere:
   PUSHF
   CLI
   IN   AL, DX                      ; get current mask
   AND  AL, AH
   OUT  DX, AL                      ; AND then output it

%IF (%PCAT) THEN
  (
   PUSH CS
   CALL PopFlags
  )
ELSE
  (
   POPF                             ; restore flags
  )
FI

CpEnableIntExit:
   POP  BP

CpMachineID PROC FAR                ; stub for CpMachineID
   RET  4
CpMachineID ENDP
CpEnableInterrupt ENDP

PURGE mode, interruptID
$EJ

;    CpDisableInterrupt : PROCEDURE (interruptID) CLEAN;
;        DCL interruptID BYTE;
;
;    This will disable the interrupt of the given ID.  It will not
;    change the state of any other interrupts.

interruptID EQU BYTE PTR [BP+6]

CpDisableInterrupt PROC FAR
   PUSH BP
   MOV  BP, SP

   MOV  BH, 0
   MOV  BL, interruptID

   MOV  AH, CS:interruptMask[BX]    ; AL = mask

   MOV  DX, intMask                 ; assume interrupt controller 1

   CMP  BL, int0Ctlr2               ; If not for interrupt controller 2
   JB   CpDisableIntHere            ; then no special checks needed

   MOV  ES, CS:DataFrame
   CMP  ES:systemType, IBMAT        ; If not on an AT architecture machine
   JNE  CpDisableIntExit            ; then don't do anything

   MOV  DX, intMask2                ; interrupt controller 2

CpDisableIntHere:
   PUSHF 
   CLI
   IN   AL, DX                      ; get original mask
   OR   AL, AH
   OUT  DX, AL                      ; OR in new one

%IF (%PCAT) THEN
  (
   PUSH CS
   CALL PopFlags
  )
ELSE
  (
   POPF                             ; restore flags
  )
FI

CpDisableIntExit:
   POP  BP

CpRealTimeClock PROC FAR            ; Stub for CpRealTimeClock
   RET  2
CpRealTimeClock ENDP
CpDisableInterrupt ENDP

PURGE interruptID
$EJ

;    CpSetInterrupt : PROCEDURE (interruptID, pRoutine) PTR CLEAN;
;        DCL interruptID BYTE;
;        DCL pRoutine PTR;
;
;    This will set up an interrupt vector and return the previous value.

pRoutine EQU DWORD PTR [BP+8]
interruptID EQU BYTE PTR [BP+12]

CpSetInterrupt PROC FAR
   PUSH DS
   PUSH BP
   MOV  BP, SP

   XOR  BX, BX
   MOV  DS, BX                      ; DS = interrupt vectors

   MOV  BL, interruptID
   MOV  BL, CS:interruptTable[BX]   ; BL = real interrupt number

   MOV  CX, intBase * 4             ; Assume interrupt controller 1

   CMP  interruptID, int0Ctlr2      ; If not for interrupt controller 2
   JB   CpSetIntHere                ; then no special checks needed

   MOV  ES, CS:DataFrame
   CMP  ES:systemType, IBMAT        ; If on an AT architecture machine
   JE   CpSetIntController2         ; then continue

   MOV  BX, 0FFFFH                  ; Return NULLPTR for old interrupt
   MOV  ES, BX
   MOV  BX, 0FH                     ; To indicate error
   JMP  SHORT CpSetIntExit

CpSetIntController2:
   MOV  CX, intBase2 * 4            ; interrupt controller 2

CpSetIntHere:
   SHL  BX, 1
   SHL  BX, 1                       ; BX := BX * 4

   ADD  BX, CX                      ; Add offset of 1st hardware intr vector

   PUSHF
   CLI                              ; Turn off interrupts
   
   LES  CX, DWORD PTR DS:[BX]       ; get current routine

   PUSH ES                          ; save segment

   LES  DX, pRoutine
   MOV  DS:[BX], DX                 ; save new offset
   MOV  DS:[BX+2], ES               ; save new segment

   POP  ES                          ; return old vector
   MOV  BX, CX

%IF (%PCAT) THEN
  (
   PUSH CS
   CALL PopFlags
  )
ELSE
  (
   POPF                             ; restore flags
  )
FI

CpSetIntExit:
   POP  BP
   POP  DS

CpConLineOut PROC FAR               ; stub for CpConLineOut
   RET  6
CpConLineOut ENDP
CpSetInterrupt ENDP

PURGE interruptID, pRoutine
$EJ

;    CpEndOfInterrupt : PROCEDURE (interruptID) CLEAN;
;        DCL interruptID BYTE;
;
;    This will do a specific "end of interrupt" for the given ID
;    It has been modified to work with both Interrupt Controllers (AT)

interruptID EQU BYTE PTR [BP+6]

CpEndOfInterrupt PROC FAR
   PUSH BP
   MOV  BP, SP

   MOV  BH, 0
   MOV  BL, interruptID
   MOV  AL, specificEOIBase
   OR   AL, CS:interruptTable[BX]   ; AL := (real interrupt #) OR AL

   CMP  BL, int0Ctlr2
   JB   CpEndOfInterruptForCtlr1

CpEndOfInterruptForCtlr2:
   MOV  ES, CS:DataFrame
   CMP  ES:systemType, IBMAT        ; If not on an AT architecture machine
   JNE  CpEndOfIntExit              ; then don't do anything

   OUT  interruptEOI2, AL           ; tell the chip
   MOV  AL, ctlr2IntEOI             ; satisfy interrupt that got to 2nd ctlr

CpEndOfInterruptForCtlr1:
   OUT  interruptEOI, AL            ; tell the chip

CpEndOfIntExit:
   POP  BP
   RET  2
CpEndOfInterrupt ENDP

PURGE interruptID
$EJ

;    CpSetKeyHandler : PROCEDURE (pRoutine) PTR CLEAN;
;        DCL pRoutine PTR;
;
;    This will set up a new key handler and return the old one

pRoutine EQU DWORD PTR [BP+8]

CpSetKeyHandler PROC FAR
    PUSH DS
    MOV  DS, CS:DataFrame
    PUSH BP
    MOV  BP, SP

    MOV  DX, DS:keyHandlerSeg       ; get old one

    LES  BX, pRoutine
    XCHG DS:keyHandlerOff, BX
    MOV  DS:keyHandlerSeg, ES       ; save new one

    MOV  ES, DX                      ; return old one

    POP  BP
    POP  DS
    RET  4
CpSetKeyHandler ENDP

PURGE pRoutine


;    CpSetTimerHandler : PROCEDURE (pRoutine) PTR CLEAN;
;        DCL pRoutine PTR;
;
;    This will set up a new key handler and return the old one

pRoutine EQU DWORD PTR [BP+8]

CpSetTimerHandler PROC FAR
    PUSH DS
    MOV  DS, CS:DataFrame
    PUSH BP
    MOV  BP, SP

    MOV  DX, DS:timerHandlerSeg      ; get old one

    LES  BX, pRoutine
    XCHG DS:timerHandlerOff, BX
    MOV  DS:timerHandlerSeg, ES      ; save new one

    MOV  ES, DX                      ; return old one

    POP  BP
    POP  DS
    RET  4
CpSetTimerHandler ENDP

PURGE pRoutine
$EJ

;    GlitchInt : PROCEDURE INTERRUPT;
;

GlitchInt PROC FAR
    PUSH ES
    PUSH DS
    PUSH AX
    PUSH CX
    PUSH DX
    PUSH BX
    PUSH SI
    PUSH DI
    PUSH BP

    MOV  AL, intGlitch
    PUSH AX
    CALL CpEndOfInterrupt   ; CALL CpEndOfInterrupt (intGlitch);

    POP  BP
    POP  DI
    POP  SI
    POP  BX
    POP  DX
    POP  CX
    POP  AX
    POP  DS
    POP  ES
    IRET
GlitchInt ENDP
$EJ

;    SystemTickInt : PROCEDURE INTERRUPT;
;

kbdIntBit        EQU 02H
kbd2OrMouse2Bits EQU 0CH               ; This is based on PS2/30 Bios listings

SystemTickInt PROC FAR
    PUSH ES
    PUSH DS
    MOV  DS, CS:DataFrame
    PUSH AX
    PUSH CX
    PUSH DX
    PUSH BX
    PUSH SI
    PUSH DI
    PUSH BP

    TEST DS:gridMachine, 1             ; If running on a GRiD machine
    JNZ  NowTimerInterrupt             ; then no need to check for kbd int

    CMP  DS:ibmMachineType, ps2Model30 ; If not running on IBM PS/2 Model 30
    JNE  NowTimerInterrupt             ; then no need to check for kbd int

    IN   AL, interruptPend             ; If there is not
    TEST AL, kbdIntBit                 ; a kbd interrupt pending
    JZ   NowTimerInterrupt             ; then don't call kbd int service rtn

    IN   AL, interruptPend2            ; If kbd card has not latched its int
    TEST AL, kbd2OrMouse2Bits          ; yet then don't call the ISR
    JZ   NowTimerInterrupt             ; (Or else it causes an Int 70 !!)

    PUSHF
    CALL DS:pDosInt71Routine           ; Call Model 30's int service routine

NowTimerInterrupt:
    MOV  AL, 20h                       ; this will cause two EOI's
    OUT  interruptEOI, AL              ; is this a problem?
                                       ; non specific EOI to pri int 0

    MOV  AX, CS:tickGranularity
    ADD  WORD PTR DS:sysCounter, AX    ; increment sys counter
    ADC  WORD PTR DS:sysCounter+2, 0

    CALL DWORD PTR DS:TimerHandlerOff  ; timer handler

    DEC  DS:interruptCounter           ; count # interrupts
    JNZ  SkipTimeInt

    MOV  DS:interruptCounter, 4
    PUSHF                              ; go to pc interrupt routine
    PUSH CS
    MOV  AX, OFFSET SkipTimeInt
    PUSH AX                            ; setup return address
    JMP  DWORD PTR DS:oldSysTickOff    ; go to Pc interrupt

SkipTimeInt:
    CALL TimerInterrupt                ; inform multi-tasking...

    POP  BP
    POP  DI
    POP  SI
    POP  BX
    POP  DX
    POP  CX
    POP  AX
    POP  DS
    POP  ES
    IRET
SystemTickInt ENDP
$EJ

;    CpSystemTick : PROCEDURE (mode) WORD CLEAN;
;        DCL mode BYTE;
;
;    This will turn on (mode = 1) or turn off (mode = 0) the system tick.
;    It will also return the system tick granularity.

mode EQU BYTE PTR [BP+8]

CpSystemTick PROC FAR
    PUSH DS
    PUSH BP
    MOV  BP, SP

    PUSHF
    CLI                         ; DISABLE

    CMP  mode, 2                ; if mode >= 2 then just return tickGranularity
    JAE  CpSystemCont

    MOV  AX, intSysTick         ; disable the system tick
    PUSH AX
    CALL CpDisableInterrupt

    XOR  AX, AX
    MOV  DS, AX
    MOV  BX, PcSystemTick

    CMP  mode, 0                ; IF mode = on THEN
    JE   CpSystemCont

    MOV  AX, OFFSET SystemTickInt
    MOV  WORD PTR DS:[BX], AX
    MOV  AX, SEG SystemTickInt
    MOV  WORD PTR DS:[BX+2], AX

; Now set the timer to interrupt every 14 ms

    MOV  AL, 36h                ; counter control value
    OUT  timerControl, AL 
    MOV  AL, 0ffh               ; get 1st timer byte
    OUT  timerSet, AL
    MOV  AL, 3fh                ; second timer byte
    OUT  timerSet, AL

    MOV  AX, intSysTick         ; enable the system tick
    PUSH AX
    PUSH AX                     ; mode is unused
    CALL CpEnableInterrupt

    MOV  DS, CS:DataFrame       ; set up DS reg
    MOV  DS:interruptCounter, 4   ; initialize interrupt count

CpSystemCont:
%IF (%PCAT) THEN
  (
    PUSH CS
    CALL PopFlags
  )
ELSE
  (
    POPF                          ; restore flags
  )
FI
    MOV  AX, CS:tickGranularity

    POP  BP
    POP  DS
    RET  2
CpSystemTick ENDP

PURGE mode
$EJ

;    CpAddressOf : PROCEDURE PTR CLEAN;
;
;    This will return the start of the block
;    of variables of the prom

;    NullRoutine is here to save some code

CpAddressOf PROC FAR
    MOV  AX, SEG osProcessQ
    MOV  ES, AX                    ; OsProcessQ is first variable in this area
    MOV  BX, OFFSET osProcessQ

NullRoutine PROC FAR
    RET
NullRoutine ENDP
CpAddressOf ENDP
$EJ

;    CpCatchAll : PROCEDURE (command, theData) WORD CLEAN;
;       DCL (command, theData) WORD;
;
;    This routine is used to program, and retrieve
;    information from many different parts of the system

theData EQU 8
command EQU 10

CpCatchAll PROC FAR
    PUSH DS
    MOV  DS, CS:DataFrame
    PUSH BP
    MOV  BP, SP

    MOV  AL, [BP+command]

    CMP  AL, catchReadStatusKey
    JNE  CpCatch10

    MOV  AX, keyboardStatusKey       ; read keyboard status
    JMP  SHORT CpCatchDone

CpCatch10:
    CMP  AL, catchSetStatusKey
    JNE  CpCatch20

    MOV  AX, WORD PTR [BP+theData]
    MOV  keyboardStatusKey, AX       ; set keyboard status
    JMP  SHORT CpCatchDone

CpCatch20:
    CMP  AL, catchReadDelayRepeat    
    JNE  CpCatch30

    MOV  AX, keyboardDelayRepeat     ; return keyboard delay and repeat
    JMP  SHORT CpCatchDone           ; (This is no longer supported)

CpCatch30:
    CMP  AL, catchReadDelayGranularity
    JE   ReturnDelayOrRepeatGranularity

    CMP  AL, catchReadRepeatGranularity
    JNE  CpCatchDone

ReturnDelayOrRepeatGranularity:
    MOV  AX, delayGranularity        ; delay and repeat granularity are same
;   JMP  SHORT CpCatchDone           ; and will never change (Not supported)

CpCatchDone:
    POP  BP
    POP  DS
    RET  4
CpCatchAll ENDP

PURGE command, theData
$EJ

;
;    CompassPromStart: PROCEDURE (pRoutine);
;      DCL pRoutine   PTR;
;
;    This will intialize all the parts of the computer,
;    start up the multitasking, and then boot the system

CompassPromStart PROC FAR
    CLI                           ; disable interrupts
    MOV  DS, CS:DataFrame         ; initialize DS

; initialize some keyboard stuff

    MOV  DS:keyHandlerOff, OFFSET NullRoutine
    MOV  DS:keyHandlerSeg, SEG NullRoutine

    MOV  DS:keyboardStatusKey, 0
    MOV  DS:keyboardDelayRepeat, initialDelayRepeat

    CALL InitTheKeyboard

; set up system tick for IBM-PC

    XOR  AX, AX
    MOV  ES, AX
    MOV  BX, PcSystemTick
    MOV  CX, WORD PTR ES:[BX]      ; offset of oldSysTick
    MOV  oldSysTickOff, CX
    MOV  CX, WORD PTR ES:[BX+2]    ; seg of oldSysTick
    MOV  oldSysTickSeg, CX

    MOV  DS:timerHandlerOff, OFFSET NullRoutine
    MOV  DS:timerHandlerSeg, SEG NullRoutine

    PUSH AX
    CALL CpSystemTick              ; CALL CpSystemTick (0);

    MOV  AX, intGlitch
    PUSH AX
    PUSH CS
    MOV  AX, OFFSET CGROUP:GlitchInt
    PUSH AX
    CALL CpSetInterrupt            ; CALL CpSetInterrupt (intGlitch,@glitchInt);

    STI

    POP  AX                        ; get rid of return address
    POP  AX
    CALL InitMultitasking          ; CALL InitMultiTasking (pRoutine)
CompassPromStart ENDP

CODE ENDS

    END
